


/**********************************************************************************************
 *                                                                                            *
 * Ex.3 :  Application Read BCD Touch key Out data to LCD(Use ET-BASE AVR ATMEGA128 r3 Board) *
 *                         (Format:Press key Shift + Key Other)                      		  *
 *                                                                                            *
 **********************************************************************************************
 *                                                                                            *
 *                                                                                            *
 * Target MCU     : ATMEL AVR-MEGA128                                                         *
 *       	      : X-TAL : 16 MHz                                                            *
 *                                                                                            *
 * Editor         : AVR Studio 4.15 Build 623                                                 *
 * Compiler       : WinAVR-20081205                                                           *
 * Create By      : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 * Last Update    : 10/September/2014                                                         *
 *																				              *
 * Port Interface :  -- MCU-AVR-Mega 128--	  	  	      -- Key Touch PAD 4x4 --             *
 *                                                                                            *
 *                   PA0(Input)          Connect                 BCD Colum 1                  *    
 *                   PA1(Input)          Connect                 BCD Colum 2                  *
 *                   PA2(Input)          Connect			     BCD Colum 4                  *
 *                   PA3(Input)		     Connect		  	     BCD Colum 8                  *
 *					 PA4(Input)	         Connect                 T#/R Ststus 1Key 		      *
 *                   PA5(Input)          Connec                  SHIF# Statu 2Key             *
 *                                                                                            *
 *       LCD     :   Connect 4bit data ;LCD 16x2 by                                           *
 *                                                                                            *  
 *                   PG4(output)         Connect         RS                                   *
 *                   PD7(output)         connect         E                                    *
 *                   PG0-PG3(output)     connect         Data 4 bit Low                       *
 *                                                                                            *
 *																						      *
 *       5V                                                                                   *
 *      --+--                                                                                 *
 *        |                                                                                   *
 *        +-----------------+                                                                 *
 *        |                 |                                                                 *
 *       ---                |                                                                 *
 *       |\|                |                                                                 *
 *    VR |/|<---------------|--+                                                              *
 *   10K ---                |  |  PG4    PD7            PG0   PG1    PG2    PG3               *
 *        |                 |  |   ^      ^              ^     ^      ^      ^                *
 *        |                 |  |   |      |              |     |      |      |                *
 *        +--------------+--|--|---|---+--|--+--+--+--+  |     |      |      |                *
 *      __|__            |  |  |   |   |  |  |  |  |  |  |     |      |      |                *
 *       ---             |  |  |   |   |  |  |  |  |  |  |     |      |      |                *
 *        -             1| 2| 3|  4|  5| 6| 7| 8| 9|10|11|   12|    13|    14|                *
 *                     __|__|__|___|___|__|__|__|__|__|__|___ _|___ __|___ __|_               *
 *                    |  G Vcc Vo RS  R/W E D0 D1 D2 D3 D4    D5      D6    D7 |              *
 *                    |      _____________________________________________     |              *
 *                    |     |                                             |    |              *
 *                    |     |                 Module                      |    |              *
 *                    |     |           LCD 2x16 Charecter                |    |              *  
 *                    |     |_____________________________________________|    |              *
 *                    |                                                        |              *
 *                    |________________________________________________________|              *
 *                                                                                            *                                                                                           *
 *                                                                                            *
 **********************************************************************************************/



#include <stdio.h>
#include <avr/io.h>                  //define port
#include <compat/deprecated.h>       //call function sbi(port,bit),cbi(port,bit) = Set,Clear bit
#include <avr/pgmspace.h>            //for progrm data to Area Flash

#define F_CPU 16000000UL             //CPU Clock Frequency (Hz)
#include<util/delay.h>               //util_delay


//---------------Key Function ---------------


char Check_SHIF(void)   ;
char Check_TR(void)     ;
char RD_KeyCode(void)   ;



//------------------LCD Function ------------------
void init_lcd(void)                   ;				   // Function Initial LCD
void write_ins(unsigned char cmm)     ;				   // Function write Command LCD
void write_data(unsigned char dat)    ;                // Function write data LCD
void gotolcd(unsigned char p)         ;                // Function Write position Curser
void EN_LCD()                         ;                // Function Enable Clock


//-------------- Function Delay_ms ------------------

void delay_ms(unsigned int i)
 {
   for(;i>0;i--)
      _delay_ms(1);
 }



//*************************** Main *************************

 int main (void) 
  { 
    unsigned char key,k ;

	
    char message[] = {"ET-TOUCH PAD 4x4"} ;
    char     ms1[] = {" Not!Touch Key! "} ;
    char     ms2[] = {"Touch Key  = "}    ;  
    char     ms3[] = {"Touch Key:SH+"}    ;                            

                           


    //---------------Initial Port IO ----------------

   DDRA   = 0        ;        //Set PA0..PA7 = Input for Read BCD Code Touch PAD   
   DDRD  |= 0x80     ;        //Set PD7 = Output for LCD Pin EN      
   DDRG   = 0xFF     ;        //Set PG0..PG7 = Output for Control LCD+Data
  
   PORTA = 0xFF      ;        //Set Default data 0xFF PortA =Pull-Up
   PORTD = 0         ;        //Set Default data 0  PortD       
   PORTG = 0         ;        //Set Default data 0  PortG
  

   init_lcd()                             ;	  //Initial LCD 

   
  gotolcd(0x00)                           ;	  //Start Position data on LCD
  for(k=0;k<16;k++)
    write_data(message[k])                ;	  //Sent data to LCD


   	  
  gotolcd(0x40)                           ;  //Start Position data on LCD
  for(k=0;k<16;k++)                          
 	write_data(ms1[k])                    ;  //Sent Message "Not!Touch Button" to LCD
   	

  while(1)
  {

   if(!Check_TR())                            //Step1: Check  Touch key (Check_TR()=0:Touch,1:release) 
      {
		key  = RD_KeyCode()                ;  //Step2: Read Key Code

        if( key == 0x0F)			          //Step3: Check Touch Key Shift(Touch the 1st Key) is Touch 2 Key
		 {
		    do
			 {
		      if(!Check_SHIF())	              //Step3.1 : Check Touch Key Other(Touch the 2nd Key) by 0:touch,1: not touch
			   {		             
	             key = RD_KeyCode()        ;  //Step 3.2  Read Key Code for Key Shif+Key Other

			     //---------- Step3.3:Program Respond Touch 2key for user(SHIF+Key) ------------
				 
				  switch(key)
		           {
			          case 0x01 :   //Shif+Key#1

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD	
							      write_data('"')                 ; 		     
						          write_data('1')                 ; 
					              write_data('"')                 ; 
				                  
						          break;

					  case 0x02 :   //Shif+Key#2

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD	
								  write_data('"')                 ; 		     
						          write_data('2')                 ; 
					              write_data('"')                 ; 
				                  
						          break;

					  case 0x03 :   //Shif+Key#3

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD			     
						          write_data('"')                 ; 
								  write_data('3')                 ; 
					              write_data('"')                 ; 
				                  
						          break;


			           case 0x04 :   //Shif+Key#4

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD		
								  write_data('"')                 ; 	     
						          write_data('4')                 ; 
					              write_data('"')                 ; 
				                  
						          break;

                       case 0x05 :   //Shif+Key#5

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD		
								  write_data('"')                 ; 	     
						          write_data('5')                 ; 
					              write_data('"')                 ; 
				                  
						          break;


					   case 0x06 :   //Shif+Key#6

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD		
								  write_data('"')                 ; 	 	     
						          write_data('6')                 ; 
					              write_data('"')                 ; 
				                  
						          break;


			        	case 0x07 :   //Shif+Key#7

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD		
								  write_data('"')                 ; 	 	     
						          write_data('7')                 ; 
					              write_data('"')                 ; 
				                  
						          break;


					    case 0x08 :   //Shif+Key#8

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD	
						 		  write_data('"')                 ; 	     
						          write_data('8')                 ; 
					              write_data('"')                 ; 
				                  
						          break;


					    case 0x09 :   //Shif+Key#9

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD		
								  write_data('"')                 ; 	     
						          write_data('9')                 ;
					              write_data('"')                 ; 
				                  
						          break;

				        case 0x00 :   //Shif+Key#0

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD			 
							      write_data('"')                 ;     
						          write_data('0')                 ; 
					              write_data('"')                 ; 
				                  
						          break;

				  }//switch
                     
				  while(!Check_SHIF()){;} 		   	              ;  //Wait Release 2Key (=1 exit loop)
				  
				  gotolcd(0x40)                                   ;  //Start Position data on LCD
                  for(k=0;k<16;k++)                          
 	                 write_data(ms1[k])                           ;  //Sent Message "Not!Touch Button" to LCD
					 
			    } //if Check Shif
			     										    
			  }while(!Check_TR())                                 ;   //Loop wait Touch the 2nd Key , Exit loop When release Key Shif or 2Key 	  

		 }	//if key == 0x0F
		else                                   //Step4: Check Touch Key Other don't key Shift is Touch 1 Key
		 { 
		   //---------- Step4.1:Program Respond Touch 1 key for user ------------
       
	        switch(key)
		      {
			    case 0x01 :   //Key#1

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('1')                 ; 
						   write_data('"')                 ; 
				          
						   break;

		        case 0x02 :   //Key#2

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('2')                 ; 
						   write_data('"')                 ; 
				          
						   break;


		         case 0x03 :   //Key#3

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('3')                 ; 
						   write_data('"')                 ; 
				        
						   break;

			     case 0x04 :   //Key#4

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('4')                 ; 
						   write_data('"')                 ; 
				          
						   break;


			     case 0x05 :  //Key#5

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('5')                 ; 
						   write_data('"')                 ; 
				           
						   break;


                 case 0x06 :   //Key#6

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('6')                 ; 
						   write_data('"')                 ; 
				         
						   break;

			     case 0x07 :   //Key#7

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('7')                 ; 
						   write_data('"')                 ; 
				         
						   break;

				 case 0x08 :   //Key#8

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('8')                 ; 
						   write_data('"')                 ; 
				           
						   break;

			     case 0x09 :   //Key#9

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('9')                 ; 
						   write_data('"')                 ; 
				          
						   break;

			     case 0x00 :  //Key#0

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('0')                 ; 
						   write_data('"')                 ; 
				         
						   break;

			     case 0x0A :  //Key#A(Clear)

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD
			     
				           write_data('"')                 ;  
						   write_data('A')                 ; 
						   write_data('"')                 ; 
				          
						   break;

			     case 0x0B :   //Key#B

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD
				           write_data('"')                 ;  
						   write_data('B')                 ; 
						   write_data('"')                 ; 
				          
						   break;


			     case 0x0C :   //Key#C

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD
				           write_data('"')                 ;  
						   write_data('C')                 ; 
						   write_data('"')                 ; 
				          
						   break;


			     case 0x0D :  //Key#D

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD
			     
				           write_data('"')                 ;  
						   write_data('D')                 ; 
						   write_data('"')                 ; 
				          
						   break;

			     case 0x0E :   //Key#E

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD
				           write_data('"')                 ;  
						   write_data('E')                 ; 
						   write_data('"')                 ; 
				         
						   break;

			}//Switch
		   
	     while(!Check_TR()){;} 			                   ;   //Wait Release Key (=1 exit loop) 	
		 
        gotolcd(0x40)                                      ;  //Start Position data on LCD
        for(k=0;k<16;k++)                          
          write_data(ms1[k])                               ;  //Sent Message "Not!Touch Button" to LCD
	   } //else
     
	 }	  //if Check_TR

    } 	  //while
  }       //main




 //********************************** Sub Program *********************************


//---------------------- Check Touch /Release for 2Key -------------------

char Check_SHIF(void)   
{
   char sh   ;
        
       sh  = PINA                ;   //Read Status Key
	   sh  = sh & 0x20           ;   //Mark bit PA5 (Statust Press or Release : 2Key)
	
	 if(sh != 0x20)           	     //Check Statue Key
	   return (0)                ;	 //Touch 2Key Return 0 (PA5=0)
	 else
 	   return (1)                ;	 //Release Key Return 1	(PA5=1)


}

//---------------------- Check Touch /Release 1Key -------------------

char Check_TR(void)    
 {
   char tr   ;
        
       tr  = PINA                ;   //Read Status Key
	   tr  = tr & 0x10           ;   //Mark bit PA4 (Statust Press or Release : 1 Key)
	
	 if(tr != 0x10)           	     //Check Statue Key
	   return (0)                ;	 //Touch Key Return 0 (PA4=0)
	 else
 	   return (1)                ;	 //Release Key Return 1	(PA4=1)
 }



//---------- Read BCD Key Code -----------------

 char RD_KeyCode(void) 
  {
	 unsigned int KeyCode                  ;
   
     KeyCode      = PINA                   ;   //Read Key Code
	 KeyCode      = KeyCode & 0x0F         ;   //Mark bit PA0-PA3(Key Code 4 bit)
	 return (KeyCode)                      ;
  }






//<<<<<<<<<<<<<<<<<<<---- LCD SUB ---->>>>>>>>>>>>>>>>>>>>>>

//---------- Initial LCD -----------

void init_lcd(void)
 {
  
  write_ins(0x33)              ;  //CMM Function Set
  write_ins(0x32)              ;  //CMM Function set
  write_ins(0x28)              ;  //CMM Function Set :DL(0)=4bit LCD ,N(1)=2 Line,F(0)= font 5x7 dot

  write_ins(0x0C)              ;  //CMM Display On/OFF :D=1,Display On
  write_ins(0x06)              ;  //CMM Entry :I/D(1)= DD RAM Address Increment,S(0) Cursor Shift
  write_ins(0x01)              ;  //CMM Clear Display


 }

 //------- Enable LCD -------

 void EN_LCD()
  {
    sbi(PORTD,7)        ;  //Clear bit PD7 =En = 1
	delay_ms(1)         ;
	
	cbi(PORTD,7)        ;  //Set bit PD7 =En = 0
	delay_ms(1)         ;
 }


//----------- Write Instruction LCD Command ------------

void write_ins(unsigned char cmm)
 {
     
    cbi(PORTG,4)                ; //Clear bit PG4 = RS  = 0
  
    PORTG  &= 0xF0              ; //Clear 4 bit Low of PORTG
    PORTG  |= ((cmm>>4) & 0x0F) ; //Sent Command 4 Bit High to PORTG
    EN_LCD()                    ; //Enable LCD
    delay_ms(3)                 ;
   

    PORTG &= 0xF0               ; //Clear 4 bit Low of PORTG 
    PORTG |= (cmm  & 0x0F)      ; //Clear Cmm 4 bit High and Sent Command 4 Bit Low	to PORTG
    EN_LCD()                    ;
    delay_ms(3)                 ;


 }

//----------- Write Data LCD Command ------------


 void write_data(unsigned char dat)
  {
    	   
	sbi(PORTG,4)                  ; //Set Bit PG4   = RS  = 1

	PORTG  &= 0xF0                ; //Clear 4 bit Low of PORTG 
    PORTG  |= ((dat>>4) & 0x0F)   ; //Sent Command 4 Bit High to PORTG
    EN_LCD()                      ; //Enable LCD
    delay_ms(3)                   ;
   

   	PORTG  &= 0xF0                ; //Clear 4 bit Low of PORTG
    PORTG  |= (dat & 0x0F)        ; //Clear Cmm 4 bit High and Sent Command 4 Bit Low  to PORTG
	EN_LCD()                      ;
	delay_ms(3)                   ;

  }


//------------ Move Cursor LCD ------------

void gotolcd(unsigned char p)
 {
   p |= 0x80    ;
   write_ins(p) ;
 }


  	










